//
//  MCSQLite+PGConformance.h
//  BPAdmin
//
//  Created by Michael Clark on 10-04-06.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <MCSQLite/MCSQLiteContext.h>
#import <MCSQLite/MCSQLiteResultSet.h>

// These categories wraps the MCSQLite methods with the PG signatures so that the UserDefaults mechanism can work with instances of MCSQLiteContext
// DO NOT expect this to work for anything other than the UserDefaults feature this was intended for.

@interface MCSQLiteContext (PGConformance)
- (BOOL)executeSQL:(NSString *)sql error: (NSError **)error;

- (BOOL)resultWithQuery:(NSString *)sql arguments:(NSArray *)anArray error: (NSError **)error; 
- (BOOL)resultWithQuery:(NSString *)sql bindings:(id)aKVCConformingObject error: (NSError **)error;

- (id)resultSetWithQuery:(NSString *)sql arguments:(NSArray *)anArray error: (NSError **)error; 
- (id)resultSetWithQuery:(NSString *)sql bindings:(id)aKVCConformingObject error: (NSError **)error;

- (BOOL)disconnect;

@end


@interface MCSQLiteResultSet (PGConformance)
- (unsigned int)count;

- (void)finalizeResult;

@end
